#include <Wire.h>
#include "Adafruit_MCP23017.h"
#include <ESP8266WiFi.h>
#include <PubSubClient.h>

Adafruit_MCP23017 mcp1;
Adafruit_MCP23017 mcp2;
Adafruit_MCP23017 mcp3;

const char* clientId = "iobroker-medienkoppler";
const char* ssid = "WIFI-SSID";
const char* password = "WIFI-PWD";
const char* mqtt_server = "IP ioBroker";
const int mqtt_port = 1883;

String mcp1_laststatus[16] = { "0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0" };
String mcp2_laststatus[16] = { "0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0" };
String mcp3_laststatus[16] = { "0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0" };

WiFiClient espClient;
PubSubClient client(espClient);

void setup_wifi() {
  delay(10);
  // We start by connecting to a WiFi network
  Serial.println();
  Serial.print("Connecting to ");
  Serial.println(ssid);

  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }

  randomSeed(micros());

  Serial.println("");
  Serial.println("WiFi connected");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());
}

void connectToMQTT() {
 client.setServer(mqtt_server, mqtt_port);

  // Die folgende Zeile muss einkommentiert werden, falls der MQTT-Broker eine Authentifizierung benötigt
  //if (client.connect(clientId , mqtt_user, mqtt_password)) {
  if (client.connect(clientId) ) {
    Serial.println("connected");
  }
}

void setup() {
  Serial.begin(9600);

  setup_wifi();
  
  mcp1.begin(5); // 0x20 + 5 für IC1
  mcp2.begin(6); // 0x20 + 6 für IC2
  mcp3.begin(7); // 0x20 + 7 für IC3

  connectToMQTT();
 
  setupModulPin(mcp1);
  setupModulPin(mcp2);
  setupModulPin(mcp3);
}

void setupModulPin(Adafruit_MCP23017 modul) {
  for (int pin=0; pin<16; pin++) {
    modul.pinMode(pin, INPUT); 
    modul.pullUp(pin, HIGH);
  }
}

void loop() {
  if (!client.connected()) {
    connectToMQTT();
  } 
  
  checkPinStatusModul(mcp1,1);
  checkPinStatusModul(mcp2,2);
  checkPinStatusModul(mcp3,3);
}

void checkPinStatusModul(Adafruit_MCP23017 modul, int modulNr) {
  for (int pin=0; pin<16; pin++) {

    String pinName = String("");

    if ( pin < 10 ) {
      pinName += "0";  
    }
    pinName += pin;

    String mqttTopic = String("medienkoppler/m");
    mqttTopic += modulNr;
    mqttTopic += "/p";
    mqttTopic += pinName;

    String mqttTopicValue = "";
 
    if ( modul.digitalRead(pin) == LOW ) {      
      mqttTopicValue = "true";
    } else {      
      mqttTopicValue = "false";
    }

    bool publishNewState = false;

    if ( modulNr == 1 ) {
      String lastStatusM1 = mcp1_laststatus[pin];
   
      if (!lastStatusM1.equals(mqttTopicValue)) {      
        mcp1_laststatus[pin] = mqttTopicValue;        
        publishNewState = true;        
      }
    }

    if ( modulNr == 2 ) {
      String lastStatusM2 = mcp2_laststatus[pin];
      
      if (!lastStatusM2.equals(mqttTopicValue)) { 
        mcp2_laststatus[pin] = mqttTopicValue;        
        publishNewState = true;        
      }
    }

    if ( modulNr == 3 ) {
      String lastStatusM3 = mcp3_laststatus[pin];
      
      if (!lastStatusM3.equals(mqttTopicValue)) { 
        mcp3_laststatus[pin] = mqttTopicValue;        
        publishNewState = true;        
      }
    }        

    if ( publishNewState == true ) {
      String debOutInfo = "publish";
      debOutInfo.concat(mqttTopic);
      debOutInfo.concat(" value=");
      debOutInfo.concat(mqttTopicValue);

      Serial.println(debOutInfo);  
          
      bool state = client.publish(mqttTopic.c_str(), mqttTopicValue.c_str(), true);
    }
  }
}
