#include <SPI.h>
#include <MFRC522.h>
#include <ESP8266WiFi.h>
#include <PubSubClient.h>
 
#define SS_PIN D8
#define RST_PIN D3

const char* ssid = "WIFI_NAME";
const char* password = "WIFI_PWD";
const char* mqtt_server = "IOBROKER_IP";
 
MFRC522 rfid(SS_PIN, RST_PIN); // Instance of the class
MFRC522::MIFARE_Key key;

WiFiClient espClient;
PubSubClient client(espClient);

void setup_wifi() {
  delay(10);
  // We start by connecting to a WiFi network
  Serial.println();
  Serial.print("Connecting to ");
  Serial.println(ssid);

  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }

  Serial.println("");
  Serial.println("WiFi connected");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());
}

void MQTTCallback(char* topic, byte* payload, unsigned int length) {
}

void reconnect() {
  while (!client.connected()) {
    Serial.print("Attempting MQTT connection...");
 
    // Create a random client ID
    String clientId = "MusicBox";

    // Attempt to connect
    if (client.connect(clientId.c_str())) {
      Serial.println("connected");
    }
    else
    {
      Serial.print("failed, rc=");
      Serial.print(client.state());
      Serial.println(" try again in 5 seconds");
      // Wait 5 seconds before retrying
      delay(5000);
    }
  }
}
 
void setup(void){
  SPI.begin();
  rfid.PCD_Init();
 
  Serial.begin(115200);
  Serial.println("Boot RFID-Reader...");
 
  setup_wifi();
  client.setServer(mqtt_server, 1883);
  reconnect();
  client.setCallback(MQTTCallback);
}
 
void loop(void) {
  if (!client.connected()) {
    reconnect();
  }
  
  handleRFID();
}
 
void handleRFID() {
  if (!rfid.PICC_IsNewCardPresent()) return;
  if (!rfid.PICC_ReadCardSerial()) return;

  String RFIDString = printHex(rfid.uid.uidByte, rfid.uid.size);
  Serial.println(RFIDString);
 
  client.publish("MusicBox/rfid", String(RFIDString).c_str(), true);
 
  rfid.PICC_HaltA();
  rfid.PCD_StopCrypto1();
}

 
String printHex(byte *buffer, byte bufferSize) {
  String id = "";
  for (byte i = 0; i < bufferSize; i++) {
  id += buffer[i] < 0x10 ? "0" : "";
  id += String(buffer[i], HEX);
  }
  return id;
}
