#include <ESP8266WiFi.h>
#include <PubSubClient.h>
#include "Arduino.h"
#include "SoftwareSerial.h"
#include "DFRobotDFPlayerMini.h"

SoftwareSerial mySoftwareSerial(D1, D2); // RX, TX
DFRobotDFPlayerMini myDFPlayer;

const char* ssid = "<wlan-ssid>";
const char* password = "<wlan-pwd>";
const char* mqtt_server = "<iobroker-ip>";
const int mqtt_port = 1883;

const int ledGreen = D3;
const int ledYellow = D4;
const int ledRed = D5;
const int ledBlue = D6;

WiFiClient espClient;
PubSubClient client(espClient);

int fileIndex;

void setup_wifi() {
  delay(10);
  // We start by connecting to a WiFi network
  Serial.println();
  Serial.print("Connecting to ");
  Serial.println(ssid);

  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }

  Serial.println("");
  Serial.println("WiFi connected");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());
}

void MQTTCallback(char* topic, byte* payload, unsigned int length) {
  Serial.println("Message arrived...");

  String Command = "";

  for (int i = 0; i < length; i++) {
    Command = Command + (char)payload[i];
  }  

  if ( Command.equals("red_on"))
  {
    digitalWrite(ledRed,HIGH);
    client.publish("AlarmProject/LastCommand", Command.c_str(), true);
  }
  if ( Command.equals("red_off"))
  {
    digitalWrite(ledRed,LOW);
    client.publish("AlarmProject/LastCommand", Command.c_str(), true);
  }  
  if ( Command.equals("green_on"))
  {
    digitalWrite(ledGreen,HIGH);
    client.publish("AlarmProject/LastCommand", Command.c_str(), true);
  }
  if ( Command.equals("green_off"))
  {
    digitalWrite(ledGreen,LOW);
    client.publish("AlarmProject/LastCommand", Command.c_str(), true);
  }   
  if ( Command.equals("yellow_on"))
  {
    digitalWrite(ledYellow,HIGH);
    client.publish("AlarmProject/LastCommand", Command.c_str(), true);
  }
  if ( Command.equals("yellow_off"))
  {
    digitalWrite(ledYellow,LOW);
    client.publish("AlarmProject/LastCommand", Command.c_str(), true);
  } 
  if ( Command.equals("blue_on"))
  {
    digitalWrite(ledBlue,HIGH);
    client.publish("AlarmProject/LastCommand", Command.c_str(), true);
  }
  if ( Command.equals("blue_off"))
  {
    digitalWrite(ledBlue,LOW);
    client.publish("AlarmProject/LastCommand", Command.c_str(), true);
  } 

  if ( Command.equals("change_volume_10"))
  {
    myDFPlayer.volume(10);
    client.publish("AlarmProject/Command", "", true);
    client.publish("AlarmProject/LastCommand", Command.c_str(), true);
  }
  if ( Command.equals("change_volume_20"))
  {
    myDFPlayer.volume(20);
    client.publish("AlarmProject/Command", "", true);
    client.publish("AlarmProject/LastCommand", Command.c_str(), true);
  }
  if ( Command.equals("change_volume_30"))
  {
    myDFPlayer.volume(30);
    client.publish("AlarmProject/Command", "", true);
    client.publish("AlarmProject/LastCommand", Command.c_str(), true);
  }    
 
  if ( Command.equals("play_1"))
  {
    myDFPlayer.play(1);
    client.publish("AlarmProject/Command", "", true);
    client.publish("AlarmProject/LastCommand", Command.c_str(), true);
  }
  if ( Command.equals("play_2"))
  {
    myDFPlayer.play(2);
    client.publish("AlarmProject/Command", "", true);
    client.publish("AlarmProject/LastCommand", Command.c_str(), true);
  }
  if ( Command.equals("play_3"))
  {
    myDFPlayer.play(3);
    client.publish("AlarmProject/Command", "", true);
    client.publish("AlarmProject/LastCommand", Command.c_str(), true);
  }  
}

void reconnect() {
  while (!client.connected()) {
    Serial.print("Attempting MQTT connection...");
 
    // Create a random client ID
    String clientId = "AudiPlayer1";

    // Attempt to connect
    if (client.connect(clientId.c_str())) {
      Serial.println("connected");

      client.subscribe("AlarmProject/Command");
    }
    else
    {
      Serial.print("failed, rc=");
      Serial.print(client.state());
      Serial.println(" try again in 5 seconds");
      // Wait 5 seconds before retrying
      delay(5000);
    }
  }
}

void setup()
{
  pinMode(ledRed, OUTPUT);
  pinMode(ledGreen, OUTPUT);
  pinMode(ledBlue, OUTPUT);
  pinMode(ledYellow, OUTPUT);
   
  mySoftwareSerial.begin(9600);
  Serial.begin(115200);

  setup_wifi();
  client.setServer(mqtt_server, mqtt_port);
  reconnect();
  client.setCallback(MQTTCallback);  
  
  if (!myDFPlayer.begin(mySoftwareSerial)) {  //Use softwareSerial to communicate with mp3.
    Serial.println(F("Unable to communicate with Audio-Player:"));
    Serial.println(F("1. Please recheck the connection!"));
    Serial.println(F("2. Please insert the SD card!"));
    while(true){
      delay(0); // Code to compatible with ESP8266 watch dog.
    }
  }
  Serial.println(F("Audo-Player online."));
  
  myDFPlayer.volume(5);  //Set volume value. From 0 to 30
}

void loop()
{
  client.loop();
}
