#include <ESP8266WiFi.h>
#include <PubSubClient.h>
#include "Arduino.h"
#include <Servo.h> 

Servo servoObject1; 
Servo servoObject2; 
Servo servoObject3; 

const char* ssid = "<wlan-ssid>";
const char* password = "<wlan-pwd>";
const char* mqtt_server = "<iobroker-ip>";
const int mqtt_port = 1883;

WiFiClient espClient;
PubSubClient client(espClient);

void setup_wifi() {
  delay(10);
  // We start by connecting to a WiFi network
  Serial.println();
  Serial.print("Connecting to ");
  Serial.println(ssid);

  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }

  Serial.println("");
  Serial.println("WiFi connected");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());
}

void MQTTCallback(char* topic, byte* payload, unsigned int length) {
  String Command = "";

  for (int i = 0; i < length; i++) {
    Command = Command + (char)payload[i];
  }  
  int angle = Command.toInt();

  if(strcmp(topic, "ServoControl/Servo1/Angle") == 0)
  {
    servoObject1.write(angle); 
  }

  if(strcmp(topic, "ServoControl/Servo2/Angle") == 0)
  {
    servoObject2.write(angle); 
  }

  if(strcmp(topic, "ServoControl/Servo3/Angle") == 0)  
  {
    servoObject3.write(angle); 
  }    
}

void reconnect() {
  while (!client.connected()) {
    Serial.print("Attempting MQTT connection...");
 
    // Create a random client ID
    String clientId = "ServoControl";

    // Attempt to connect
    if (client.connect(clientId.c_str())) {
      Serial.println("connected");

      client.subscribe("ServoControl/Servo1/Angle");
      client.subscribe("ServoControl/Servo2/Angle");
      client.subscribe("ServoControl/Servo3/Angle");
    }
    else
    {
      Serial.print("failed, rc=");
      Serial.print(client.state());
      Serial.println(" try again in 5 seconds");
      // Wait 5 seconds before retrying
      delay(5000);
    }
  }
}

void setup()
{
  Serial.begin(115200);

  servoObject1.attach(D2); 
  servoObject2.attach(D3); 
  servoObject3.attach(D4); 

  setup_wifi();
  client.setServer(mqtt_server, mqtt_port);
  reconnect();
  client.setCallback(MQTTCallback);  
}

void loop()
{
  client.loop();
}
