#include <ESP8266WiFi.h>
#include <PubSubClient.h>
WiFiClient espClient; 
PubSubClient client(espClient); 

bool water_detected = true;
char tmp[50];

char* clientId = "KellerWassermelder001";
const char* wifi_ssid = "<wlan-ssid>";
const char* wifi_password = "<wlan-pwd>";
const char* mqtt_server = "<iobroker-ip>";
const int mqtt_port = 1883;
const char* mqtt_user = "user";
const char* mqtt_password = "pwd";


void connectToMQTT() {
 client.setServer(mqtt_server, mqtt_port);

  // Die folgende Zeile muss einkommentiert werden, falls der MQTT-Broker eine Authentifizierung benötigt
  //if (client.connect(clientId , mqtt_user, mqtt_password)) {
  if (client.connect(clientId) ) {
    Serial.println("connected");
  }
}

void setup() {
  // WIFI-Verbindung aufbauen
  WiFi.begin(wifi_ssid, wifi_password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
  }
  
  connectToMQTT();
  delay(3000);
}

void loop() {
  if (!client.connected()) {
    connectToMQTT();
  }
  
  client.publish("KellerWassermelder001/water_detected", "on");
  
  if (water_detected == true ) {
    // Signalstärke der WLAN-Verbindung auslesen
    long rssi = WiFi.RSSI();
    itoa(rssi,tmp,10);
    client.publish("KellerWassermelder001/water_detection_rssi", tmp);
    delay(3000);

    // ESP in den DeepSleep-Modus setzen
    ESP.deepSleep(0);
    delay(100);
  }  
}
